/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.managedsystem;

import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.managedsystem.ActivateException;
import com.ibm.hwmca.fw.service.managedsystem.AlreadyLockedException;
import com.ibm.hwmca.fw.service.managedsystem.DeactivateException;
import com.ibm.hwmca.fw.service.managedsystem.IdentifyException;
import com.ibm.hwmca.fw.service.managedsystem.LockingException;
import com.ibm.hwmca.fw.service.managedsystem.QueryType;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementException;
import com.ibm.hwmca.fw.service.managedsystem.VerifyException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUIDFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ServiceableElement
implements Persistable,
QueryType {
    private static final String TRACE_MASKT = "XRVFSE_T";
    private static final String TRACE_MASKF = "XRVFSE_F";
    private static final String TRACE_MASKD = "XRVFSE_D";
    public String uniqueKey = null;
    public static final int SET_SERVICE_POSITION = 0;
    public static final int REMOVE = 1;
    public static final int INSTALL = 2;
    public static final int RESET_SERVICE_POSITION = 3;
    protected Map properties = new HashMap();

    public PersistentData getPersistentData() {
        PersistentDataImpl data = new PersistentDataImpl();
        data.properties = this.properties;
        data.uniqueKey = this.uniqueKey;
        return data;
    }

    public ServiceableElement() {
        Trace.trace(TRACE_MASKT, "<> ServiceableElement default ctor");
        this.uniqueKey = UUIDFactory.generate().toString();
    }

    public ServiceableElement(Map properties) {
        Trace.trace(TRACE_MASKF, "ServiceableElement ctor: properties" + properties);
        this.properties = properties;
    }

    public ServiceableElement(PersistentData persistentData) {
        PersistentDataImpl persistentDataImpl = (PersistentDataImpl)persistentData;
        Trace.trace(TRACE_MASKT, "-> ServiceableElement ctor from PersistentData");
        Trace.trace(TRACE_MASKT, "\t\t\t-uniqueKey=" + persistentDataImpl.uniqueKey);
        this.uniqueKey = persistentDataImpl.uniqueKey;
        this.properties = persistentDataImpl.properties;
    }

    public final String getUniqueKey() {
        Trace.trace(TRACE_MASKT, "<> ServiceableElement.getUniqueKey [" + this.uniqueKey + "]");
        return this.uniqueKey;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void putProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }

    public Object getProperty(Object key) {
        Object o = null;
        if (this.properties != null) {
            o = this.properties.get(key);
        }
        return o;
    }

    public void displayServiceEffect(Map userData) throws ServiceableElementException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.displayServiceEffect; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void setServiceLock(Map userData) throws AlreadyLockedException, LockingException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.setServiceLock; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void resetServiceLock(Map userData) throws LockingException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.resetServiceLock; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void identify(Map userData) throws IdentifyException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.identify; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void resetIdentify(Map userData) throws IdentifyException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.resetIdentify; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void applicationLevelDeactivate(Map userData) throws DeactivateException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.applicationLevelDeactivate; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void systemLevelDeactivate(Map userData) throws DeactivateException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.systemLevelDeactivate; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void elementLevelDeactivate(Map userData) throws DeactivateException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.elementLevelDeactivate; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void elementLevelActivate(Map userData) throws ActivateException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.elementLevelActivate; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void elementLevelVerify(Map userData) throws VerifyException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.elementLevelVerify; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void systemLevelActivate(Map userData) throws ActivateException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.systemLevelActivate; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void systemLevelVerify(Map userData) throws VerifyException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.systemLevelVerify; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void applicationLevelActivate(Map userData) throws ActivateException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.applicationLevelActivate; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public void applicationLevelVerify(Map userData) throws VerifyException {
        Trace.trace(TRACE_MASKT, "<>ServiceableElement.applicationLevelVerify; Default NO-OP method called for id:" + this.uniqueKey);
    }

    public List getInstallPanelSequence(Map userData) {
        return Collections.EMPTY_LIST;
    }

    public List getRemovePanelSequence(Map userData) {
        return Collections.EMPTY_LIST;
    }

    public List getSetServicePositionPanelSequence(Map userData) {
        return Collections.EMPTY_LIST;
    }

    public List getResetServicePositionPanelSequence(Map userData) {
        return Collections.EMPTY_LIST;
    }

    public void prepare(Map userData) throws ServiceableElementException {
    }

    public static class PersistentDataImpl
    implements PersistentData {
        public Map properties;
        public String uniqueKey;
        static final long serialVersionUID = 1L;
    }
}

